<?php
// ===============================================
// API: add_stofblok.php
// Doel: nieuw stofblok aanmaken voor een examen
// ===============================================
require '../config.php';
header('Content-Type: application/json; charset=utf-8');

try {
    // JSON body verwerken
    $in = json_decode(file_get_contents('php://input'), true);
    if (!is_array($in)) $in = [];

    // Sta beide keys toe: exameneenheid of exameneenheid_id
    $exameneenheid_id = isset($in['exameneenheid_id']) ? (int)$in['exameneenheid_id']
                     : (isset($in['exameneenheid']) ? (int)$in['exameneenheid'] : 0);

    $titel = trim($in['titel'] ?? '');

    if ($exameneenheid_id <= 0 || $titel === '') {
        throw new Exception('Ontbrekende of ongeldige velden (exameneenheid_id en titel verplicht).');
    }

    // Controle: bestaat de exameneenheid?
    $chk = $pdo->prepare('SELECT id FROM exameneenheden WHERE id = ?');
    $chk->execute([$exameneenheid_id]);
    if (!$chk->fetchColumn()) {
        throw new Exception('Onbekende exameneenheid_id.');
    }

    // Invoegen met defaults (checkboxen op 0, score op 0)
    $stmt = $pdo->prepare("
        INSERT INTO stofblokken (exameneenheid_id, titel, beschrijving, samengevat, geleerd, overhoord, geoefend, score)
        VALUES (:ex, :titel, '', 0, 0, 0, 0, 0)
    ");
    $stmt->execute([
        ':ex'    => $exameneenheid_id,
        ':titel' => $titel,
    ]);

    $id = (int)$pdo->lastInsertId();

    // (Optioneel) alvast lege reflectie-rij aanmaken in `reflecties`
    // Handig als je UNIQUE KEY op (stofblok_id) hebt.
    try {
        $pdo->prepare("
            INSERT INTO reflecties (stofblok_id, moeilijk, uitleg, status, datum)
            VALUES (?, '', '', '', NOW())
            ON DUPLICATE KEY UPDATE datum = VALUES(datum)
        ")->execute([$id]);
    } catch (\Throwable $e) {
        // Stil negeren als tabel/constraint nog niet bestaat
    }

    echo json_encode([
        'status' => 'ok',
        'stofblok' => [
            'id' => $id,
            'exameneenheid_id' => $exameneenheid_id,
            'titel' => $titel,
            'samengevat' => 0,
            'geleerd' => 0,
            'overhoord' => 0,
            'geoefend' => 0,
            'score' => 0,
            // reflectie leeg
            'moeilijk' => '',
            'uitleg'   => '',
            'status'   => '',
        ]
    ]);
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}

