<?php
require '../config.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);
$exameneenheid_id = (int)($data['exameneenheid_id'] ?? 0);
$taak = trim($data['taak'] ?? '');

if (!$exameneenheid_id || $taak === '') {
  http_response_code(400);
  echo json_encode(['status'=>'error','message'=>'Ontbrekende velden']);
  exit;
}

$stmt = $pdo->prepare("INSERT INTO todo (exameneenheid_id, taak) VALUES (?, ?)");
$stmt->execute([$exameneenheid_id, $taak]);

echo json_encode(['status'=>'ok']);

