<?php
require '../config.php';
header('Content-Type: application/json');

$id = (int)($_GET['exameneenheid_id'] ?? 0);
if ($id <= 0) { echo json_encode([]); exit; }

$stmt = $pdo->prepare("
    SELECT veld, waarde
    FROM reflectie
    WHERE exameneenheid_id = :id
      AND opgeslagen_op = (
        SELECT MAX(r2.opgeslagen_op)
        FROM reflectie r2
        WHERE r2.exameneenheid_id = reflectie.exameneenheid_id
          AND r2.veld = reflectie.veld
      )
");
$stmt->execute(['id' => $id]);
$out = [];
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $r) {
    $out[$r['veld']] = $r['waarde'];
}
echo json_encode($out);

