<?php
// api/gettodos.php
require '../config.php';

// Zorg voor schone JSON-output en geen caching
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

try {
    // exameneenheid_id mag via GET of POST binnenkomen; we pakken wat er is.
    $raw = $_GET['exameneenheid_id'] ?? $_GET['id'] ?? $_POST['exameneenheid_id'] ?? $_POST['id'] ?? null;
    $exameneenheidId = filter_var($raw, FILTER_VALIDATE_INT);

    if (!$exameneenheidId || $exameneenheidId <= 0) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'error'   => 'Ongeldig of ontbrekend exameneenheid_id',
            'data'    => []
        ], JSON_UNESCAPED_UNICODE);
        exit;
    }

    // Simpele, duidelijke query: geef ALLE items terug voor deze exameneenheid
    $stmt = $pdo->prepare("
        SELECT id, taak, COALESCE(voltooid, 0) AS voltooid, aangemaakt_op, voltooid_op
        FROM todo
        WHERE exameneenheid_id = :id
        ORDER BY aangemaakt_op DESC, id DESC
    ");
    $stmt->execute(['id' => $exameneenheidId]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'count'   => count($rows),
        'data'    => $rows
    ], JSON_UNESCAPED_UNICODE);

} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error'   => $e->getMessage(),
        'data'    => []
    ], JSON_UNESCAPED_UNICODE);
}

