<?php
require '../config.php';
header('Content-Type: application/json');

$in = json_decode(file_get_contents('php://input'), true);
$stofblok_id = (int)($in['id'] ?? 0);
$veld = $in['veld'] ?? null;       // 'moeilijk' | 'uitleg' | 'status'
$waarde = $in['waarde'] ?? '';

if (!$stofblok_id || !in_array($veld, ['moeilijk','uitleg','status'], true)) {
  http_response_code(400);
  echo json_encode(['status'=>'error','message'=>'Ongeldige invoer']);
  exit;
}

// Upsert: maak rij als die niet bestaat, anders update kolom
$pdo->beginTransaction();
$pdo->prepare("
  INSERT INTO reflecties (stofblok_id, $veld, datum) VALUES (?, ?, NOW())
  ON DUPLICATE KEY UPDATE $veld = VALUES($veld), datum = NOW()
")->execute([$stofblok_id, $waarde]);
$pdo->commit();

echo json_encode(['status'=>'ok']);

