<?php
// ==========================================================
// API: update_stofblok.php
// Doel: een veld (checkbox of slider) van een stofblok bijwerken
// ==========================================================
require '../config.php';
header('Content-Type: application/json');

try {
    // Lees JSON-data uit het request
    $input = json_decode(file_get_contents('php://input'), true);

    if (!isset($input['id'], $input['veld'])) {
        throw new Exception('Ongeldige invoer (ontbrekende velden).');
    }

    $id = (int)$input['id'];
    $veld = $input['veld'];
    $waarde = isset($input['waarde']) ? $input['waarde'] : null;

    // Alleen deze kolommen mogen aangepast worden
    $toegestaneVelden = ['samengevat', 'geleerd', 'overhoord', 'geoefend', 'score'];
    if (!in_array($veld, $toegestaneVelden, true)) {
        throw new Exception('Ongeldig veld.');
    }

    // Zet logische waarden correct om
    if (in_array($veld, ['samengevat', 'geleerd', 'overhoord', 'geoefend'], true)) {
        $waarde = (int)!empty($waarde);
    } else {
        // veld = score
        $waarde = max(0, min(10, (int)$waarde)); // begrens slider op 0?10
    }

    // Update uitvoeren
    $stmt = $pdo->prepare("UPDATE stofblokken SET `$veld` = :waarde WHERE id = :id");
    $stmt->execute(['waarde' => $waarde, 'id' => $id]);

    echo json_encode(['status' => 'ok', 'veld' => $veld, 'waarde' => $waarde]);
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}

