<?php
require '../config.php';
header('Content-Type: application/json');

try {
    // ? Invoer controleren
    $id = (int)($_POST['id'] ?? 0);
    $voltooid = (int)($_POST['voltooid'] ?? 0);

    if ($id <= 0) {
        echo json_encode(['success' => false, 'error' => 'Geen geldig ID opgegeven']);
        exit;
    }

    // ? Bijwerken van status en voltooid_op
    $stmt = $pdo->prepare("
        UPDATE todo
        SET voltooid = :voltooid,
            voltooid_op = CASE
                WHEN :voltooid = 1 THEN NOW()
                ELSE NULL
            END
        WHERE id = :id
    ");
    $stmt->execute(['voltooid' => $voltooid, 'id' => $id]);

    // ? Bevestiging teruggeven met huidige status
    $stmt2 = $pdo->prepare("SELECT id, taak, voltooid, voltooid_op FROM todo WHERE id = :id");
    $stmt2->execute(['id' => $id]);
    $updated = $stmt2->fetch(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'updated' => $updated
    ]);

} catch (Throwable $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

