<?php
require '../config.php';
header('Content-Type: application/json');

try {
    if (!isset($_FILES['bestand']) || !isset($_POST['vak_id'])) {
        throw new Exception('Geen bestand of vak_id ontvangen.');
    }

    $vak_id = (int)$_POST['vak_id'];
    $f = $_FILES['bestand'];

    if ($f['error'] !== UPLOAD_ERR_OK) {
        throw new Exception('Uploadfout code: ' . $f['error']);
    }

    // Map per vak: uploads/vak_<vak_id>/
    $baseDir = realpath(__DIR__ . '/..');        // ?/examenplanner
    $relDir  = 'uploads/vak_' . $vak_id . '/';
    $absDir  = $baseDir . '/' . $relDir;

    if (!is_dir($absDir)) {
        if (!mkdir($absDir, 0777, true) && !is_dir($absDir)) {
            throw new Exception('Kan uploadmap niet aanmaken.');
        }
    }

    // Veilige bestandsnaam
    $origName = $f['name'];
    $safeName = preg_replace('/[^A-Za-z0-9._-]/', '_', $origName);
    $stored   = time() . '_' . $safeName;

    // Relatief pad dat we in de DB opslaan
    $relPath = $relDir . $stored;
    $absPath = $absDir . $stored;

    if (!move_uploaded_file($f['tmp_name'], $absPath)) {
        throw new Exception('Verplaatsen van upload mislukt.');
    }

    // Schrijf naar DB (let op kolomnaam bestandslocatie)
    $stmt = $pdo->prepare("
        INSERT INTO vakdocumenten (vak_id, bestandsnaam, bestandslocatie, upload_datum)
        VALUES (?, ?, ?, NOW())
    ");
    $stmt->execute([$vak_id, $origName, $relPath]);

    echo json_encode([
        'status'           => 'ok',
        'bestandsnaam'     => $origName,
        'bestandslocatie'  => $relPath
    ]);
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}

