// ==========================================================
// Examenplanner Frontend Script
// ==========================================================

window.addEventListener('DOMContentLoaded', () => {

  // ==============================
  // 1️⃣ Tabs activeren
  // ==============================
  document.querySelectorAll('.tab-links a').forEach(link => {
    link.addEventListener('click', e => {
      e.preventDefault();
      const target = link.getAttribute('href');
      document.querySelectorAll('.tab-links li').forEach(li => li.classList.remove('active'));
      document.querySelectorAll('.tab-content .tab').forEach(tab => tab.classList.remove('active'));
      link.parentElement.classList.add('active');
      document.querySelector(target).classList.add('active');
    });
  });

  // ==============================
  // 2️⃣ Checkboxen bijwerken
  // ==============================
  document.querySelectorAll('.checkveld').forEach(cb => {
    cb.addEventListener('change', async () => {
      const id = cb.dataset.id;
      const veld = cb.dataset.veld;
      const waarde = cb.checked ? 1 : 0;
      try {
        await fetch('api/update_stofblok.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify({ id, veld, waarde })
        });
      } catch (err) {
        console.error('Fout bij checkbox-update:', err);
      }
    });
  });

  // ==============================
  // 3️⃣ Score-slider opslaan
  // ==============================
  document.querySelectorAll('.score-slider').forEach(slider => {
    slider.addEventListener('change', async () => {
      const id = slider.dataset.id;
      const waarde = slider.value;
      try {
        await fetch('api/update_stofblok.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify({ id, veld: 'score', waarde })
        });
      } catch (err) {
        console.error('Fout bij opslaan score:', err);
      }
    });
  });

  // ==============================
  // 4️⃣ Reflectievelden opslaan (per stofblok)
  // ==============================
  document.querySelectorAll('.reflectieveld').forEach(el => {
    el.addEventListener('blur', async () => {
      const id = el.closest('tr').dataset.stofblok;
      const veld = el.dataset.veld;
      const waarde = el.value;
      try {
        await fetch('api/save_reflectie.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify({ id, veld, waarde })
        });
      } catch (err) {
        console.error('Fout bij opslaan reflectie:', err);
      }
    });
  });

  // ==============================
  // 5️⃣ Nieuw stofblok toevoegen
  // ==============================
  document.querySelectorAll('.btn-add').forEach(btn => {
    btn.addEventListener('click', async () => {
      const exameneenheid = btn.dataset.exameneenheid;
      const input = btn.previousElementSibling;
      const titel = input.value.trim();
      if (!titel) return;

      try {
        const resp = await fetch('api/add_stofblok.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify({ exameneenheid, titel })
        });
        if (resp.ok) {
          const sectie = btn.closest('.stofblokken-sectie');
          const tabel = sectie.querySelector('table');
          const tr = document.createElement('tr');
          tr.innerHTML = `
            <td>${titel}</td>
            <td colspan="8"><em>Nieuw stofblok toegevoegd (pagina verversen om te bewerken)</em></td>`;
          tabel.appendChild(tr);
          input.value = '';
        }
      } catch (err) {
        console.error('Fout bij toevoegen stofblok:', err);
      }
    });
  });

  // ==============================
  // 6️⃣ To-do toevoegen (exameneenheid_id, taak)
  // ==============================
  document.querySelectorAll('.todo-btn').forEach(btn => {
    btn.addEventListener('click', async () => {
      const sectie = btn.closest('.todo');
      const exameneenheid_id = sectie.dataset.examen;
      const input = sectie.querySelector('.todo-input');
      const taak = input.value.trim();
      if (!taak) return;

      try {
        const resp = await fetch('api/add_todo.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify({ exameneenheid_id, taak })
        });
        if (resp.ok) {
          const ul = sectie.querySelector('.todo-list');
          const li = document.createElement('li');
          li.textContent = taak;
          ul.prepend(li);
          input.value = '';
        } else {
          console.warn('Server reageerde niet OK bij toevoegen todo');
        }
      } catch (err) {
        console.error('Fout bij toevoegen todo:', err);
      }
    });
  });

  // ==============================
  // 7️⃣ Upload van vakdocumenten
  // ==============================
  document.querySelectorAll('.upload-form').forEach(form => {
    form.addEventListener('submit', async e => {
      e.preventDefault();
      const sectie = form.closest('.vakdocumenten');
      const vak_id = sectie.dataset.vak;
      const fileInput = form.querySelector('.file-input');
      const bestand = fileInput.files[0];
      if (!bestand) return;

      const formData = new FormData();
      formData.append('bestand', bestand);
      formData.append('vak_id', vak_id);

      try {
        const resp = await fetch('api/upload_vakdocument.php', {
          method: 'POST',
          body: formData
        });
        const result = await resp.json();

        if (result.status === 'ok') {
          const ul = sectie.querySelector('.doc-lijst');
          const li = document.createElement('li');
          li.innerHTML = `<a href="${result.bestandslocatie}" target="_blank">${result.bestandsnaam}</a> <span class="datum">(zojuist)</span>`;
          ul.prepend(li);
          fileInput.value = '';
        } else {
          alert('Upload mislukt: ' + result.message);
        }
      } catch (err) {
        alert('Fout bij uploaden: ' + err.message);
      }
    });
  });

});
