<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require 'config.php';

$today = date('Y-m-d');
$future = date('Y-m-d', strtotime('+2 months'));

$vakken = $pdo->query("SELECT * FROM vakken ORDER BY naam")->fetchAll();

$stmt = $pdo->prepare("
    SELECT e.*, v.naam AS vak_naam
    FROM exameneenheden e
    JOIN vakken v ON v.id = e.vak_id
    WHERE (e.datum_start BETWEEN :start AND :end)
       OR (e.datum_eind BETWEEN :start AND :end)
    ORDER BY v.naam, e.datum_start
");
$stmt->execute(['start' => $today, 'end' => $future]);
$examens = $stmt->fetchAll(PDO::FETCH_ASSOC);

$perVak = [];
foreach ($examens as $ex) $perVak[$ex['vak_id']][] = $ex;
?>
<!DOCTYPE html>
<html lang="nl">
<head>
  <meta charset="UTF-8">
  <title>Examenplanner</title>
  <link rel="stylesheet" href="assets/style.css">
  <script src="assets/script.js" defer></script>
</head>
<body>
<h1>?? Examenplanner ? Komende 2 maanden</h1>

<div class="tabs">
  <ul class="tab-links">
    <?php foreach ($vakken as $i => $vak): ?>
      <li class="<?= $i === 0 ? 'active' : '' ?>">
        <a href="#tab<?= $vak['id'] ?>"><?= htmlspecialchars($vak['naam']) ?></a>
      </li>
    <?php endforeach; ?>
  </ul>

  <div class="tab-content">
    <?php foreach ($vakken as $i => $vak): ?>
      <div id="tab<?= $vak['id'] ?>" class="tab <?= $i === 0 ? 'active' : '' ?>">

        <!-- === VAKDOCUMENTEN BOVENAAN === -->
        <div class="vakdocumenten" data-vak="<?= $vak['id'] ?>">
          <h4>?? Vakdocumenten</h4>

          <form class="upload-form" enctype="multipart/form-data">
            <input type="file" name="bestand" class="file-input" required>
            <button type="submit" class="upload-btn">Uploaden</button>
          </form>

          <ul class="doc-lijst">
            <?php
            try {
              $docs = $pdo->prepare("SELECT * FROM vakdocumenten WHERE vak_id = ? ORDER BY upload_datum DESC");
              $docs->execute([$vak['id']]);
              if ($docs->rowCount() > 0) {
                foreach ($docs as $d):
                  $pad = !empty($d['bestandslocatie']) ? htmlspecialchars($d['bestandslocatie']) : '#';
                  $naam = htmlspecialchars($d['bestandsnaam'] ?? 'Onbekend');
                  $datum = !empty($d['upload_datum']) ? date('d-m-Y H:i', strtotime($d['upload_datum'])) : '';
                  echo "<li><a href='{$pad}' target='_blank'>{$naam}</a> <span class='datum'>($datum)</span></li>";
                endforeach;
              } else {
                echo "<li><em>Geen documenten gevonden.</em></li>";
              }
            } catch (Exception $e) {
              echo "<li><em>Geen documenten gevonden.</em></li>";
            }
            ?>
          </ul>
        </div>

        <!-- === EXAMENEENHEDEN === -->
        <?php if (!empty($perVak[$vak['id']])): ?>
          <?php foreach ($perVak[$vak['id']] as $ex): ?>
            <div class="exameneenheid-kaart">
              <header class="exam-header">
                <h3><?= htmlspecialchars($ex['titel']) ?></h3>
                <div class="datum">
                  <?php
                  if ($ex['datum_eind'] && $ex['datum_eind'] !== $ex['datum_start'])
                    echo date('d-m-Y', strtotime($ex['datum_start'])) . ' ? ' . date('d-m-Y', strtotime($ex['datum_eind']));
                  else
                    echo date('d-m-Y', strtotime($ex['datum_start']));
                  ?>
                </div>
              </header>

              <div class="exam-body">
                <?php if ($ex['onderwerp']): ?>
                  <p><strong>Onderwerp:</strong> <?= htmlspecialchars($ex['onderwerp']) ?></p>
                <?php endif; ?>
                <?php if ($ex['te_bestuderen_stof']): ?>
                  <p><strong>Te bestuderen stof:</strong> <?= nl2br(htmlspecialchars($ex['te_bestuderen_stof'])) ?></p>
                <?php endif; ?>
              </div>

              <!-- === STOFBLOKKEN + REFLECTIE === -->
              <div class="stofblokken-sectie" data-exameneenheid="<?= $ex['id'] ?>">
                <h4>?? Stofblokken</h4>
                <table class="stof-tabel">
                  <tr>
                    <th style="width:20%">Blok</th>
                    <th class="smal">Samengevat</th>
                    <th class="smal">Geleerd</th>
                    <th class="smal">Overhoord</th>
                    <th class="smal">Geoefend</th>
                    <th style="width:8%">Score</th>
                    <th>Wat vind ik moeilijk?</th>
                    <th>Waar heb ik uitleg van nodig?</th>
                    <th>Hoe sta ik ervoor?</th>
                  </tr>

                  <?php
                  $stof = $pdo->prepare("SELECT * FROM stofblokken WHERE exameneenheid_id=?");
                  $stof->execute([$ex['id']]);
                  $stof = $stof->fetchAll(PDO::FETCH_ASSOC);

                  foreach ($stof as $s):
                    try {
                      $reflectieStmt = $pdo->prepare("
                          SELECT moeilijk, uitleg, status 
                          FROM reflecties 
                          WHERE stofblok_id = ? 
                          ORDER BY id DESC LIMIT 1
                      ");
                      $reflectieStmt->execute([$s['id']]);
                      $reflectie = $reflectieStmt->fetch(PDO::FETCH_ASSOC) ?: ['moeilijk'=>'','uitleg'=>'','status'=>''];
                    } catch (Exception $e) {
                      $reflectie = ['moeilijk'=>'','uitleg'=>'','status'=>''];
                    }

                    $score = isset($s['score']) ? intval($s['score']) : 0;
                  ?>
                  <tr data-stofblok="<?= $s['id'] ?>">
                    <td><?= htmlspecialchars($s['titel']) ?></td>

                    <?php foreach (['samengevat','geleerd','overhoord','geoefend'] as $veld): ?>
                      <td class="center">
                        <input type="checkbox"
                               class="checkveld"
                               data-id="<?= $s['id'] ?>"
                               data-veld="<?= $veld ?>"
                               <?= $s[$veld] ? 'checked' : '' ?>>
                      </td>
                    <?php endforeach; ?>

                    <td class="center">
                      <input type="range" min="0" max="10" value="<?= $score ?>"
                             class="score-slider" data-id="<?= $s['id'] ?>">
                    </td>

                    <td><textarea class="reflectieveld" data-veld="moeilijk"><?= htmlspecialchars($reflectie['moeilijk']) ?></textarea></td>
                    <td><textarea class="reflectieveld" data-veld="uitleg"><?= htmlspecialchars($reflectie['uitleg']) ?></textarea></td>
                    <td><textarea class="reflectieveld" data-veld="status"><?= htmlspecialchars($reflectie['status']) ?></textarea></td>
                  </tr>
                  <?php endforeach; ?>
                </table>

                <div class="nieuw-blok">
                  <input type="text" class="nieuw-titel" placeholder="Nieuwe stofblok titel...">
                  <button type="button" class="btn-add" data-exameneenheid="<?= $ex['id'] ?>">Toevoegen</button>
                </div>
              </div>

              <!-- === TODO-LIJST === -->
              <div class="todo" data-examen="<?= $ex['id'] ?>">
                <h4>?? To-do lijstje</h4>
                <ul class="todo-list">
                  <?php
                  try {
                    $todos = $pdo->prepare("SELECT taak FROM todo WHERE exameneenheid_id = ? ORDER BY id DESC");
                    $todos->execute([$ex['id']]);
                    foreach ($todos as $t):
                      echo "<li>" . htmlspecialchars($t['taak']) . "</li>";
                    endforeach;
                  } catch (Exception $e) {
                    echo "<li><em>Geen taken gevonden.</em></li>";
                  }
                  ?>
                </ul>
                <div class="todo-add">
                  <input type="text" class="todo-input" placeholder="Nieuwe taak...">
                  <button class="todo-btn">Toevoegen</button>
                </div>
              </div>

            </div>
          <?php endforeach; ?>
        <?php else: ?>
          <p><em>Geen exameneenheden gepland in de komende 2 maanden voor dit vak.</em></p>
        <?php endif; ?>

      </div>
    <?php endforeach; ?>
  </div>
</div>
</body>
</html>

