<?php
session_start();

// Controleer of gebruiker al is ingelogd
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    header("Location: index.php");
    exit;
}

$error = "";
$showWelcome = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    // Voorbeeld login
    if ($username === 'ids' && $password === 'examen') {
        $_SESSION['loggedin'] = true;
        $showWelcome = true;
    } else {
        $error = "Ongeldige gebruikersnaam of wachtwoord.";
    }
}
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Examenplanner - Inloggen</title>
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', sans-serif;
            color: #fff;
            background-color: #1e1e1e;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        form {
            background-color: #2a2a2a;
            padding: 30px 40px;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0,0,0,0.5);
            width: 320px;
        }

        h2 {
            text-align: center;
            margin-bottom: 20px;
            color: #fff;
        }

        label {
            display: block;
            margin-top: 10px;
            color: #ddd;
        }

        input[type="text"], input[type="password"] {
            width: 100%;
            padding: 8px;
            margin-top: 5px;
            background-color: #1e1e1e;
            border: 1px solid #555;
            color: #fff;
            border-radius: 5px;
        }

        button {
            margin-top: 20px;
            width: 100%;
            padding: 10px;
            background-color: #3a3a3a;
            color: #fff;
            border: 1px solid #555;
            border-radius: 5px;
            cursor: pointer;
        }

        button:hover {
            background-color: #555;
        }

        .error {
            color: #ff7070;
            margin-top: 10px;
            font-size: 14px;
            text-align: center;
        }

        /* Welkomstscherm */
        .welcome-container {
            position: relative;
            width: 100%;
            height: 100vh;
            overflow: hidden;
            background: linear-gradient(135deg, #2a2a2a, #3e1f47, #293462);
            animation: bgmove 10s infinite alternate;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
        }

        @keyframes bgmove {
            0% { background-position: 0% 50%; }
            100% { background-position: 100% 50%; }
        }

        .welcome-container h1 {
            font-size: 2.5em;
            margin-bottom: 10px;
            color: #fff;
        }

        .countdown {
            font-size: 1.2em;
            color: #ffdf6b;
            margin-top: 10px;
        }

        .subtext {
            margin-top: 20px;
            font-size: 1em;
            color: #ccc;
        }
    </style>
</head>
<body>

<?php if ($showWelcome): ?>
    <div class="welcome-container">
        <h1>Hi Ids! Welkom terug bij je Examenplanner! 🎓</h1>
        <p class="subtext">Nog even tot je laatste examen...</p>
        <div class="countdown" id="countdown">Laden...</div>
        <p class="subtext">(Je wordt automatisch doorgestuurd)</p>
    </div>

    <script>
        // Aftelklok tot 20 mei 2026
        const examDate = new Date("2026-05-20T00:00:00");
        const countdownEl = document.getElementById("countdown");

        function updateCountdown() {
            const now = new Date();
            const diff = examDate - now;

            if (diff <= 0) {
                countdownEl.textContent = "Het is zover! Succes met je examen! 🎉";
                return;
            }

            const days = Math.floor(diff / (1000 * 60 * 60 * 24));
            const hours = Math.floor((diff / (1000 * 60 * 60)) % 24);
            const mins = Math.floor((diff / (1000 * 60)) % 60);
            const secs = Math.floor((diff / 1000) % 60);

            countdownEl.textContent = `${days} dagen, ${hours} uur, ${mins} min, ${secs} sec`;
        }

        setInterval(updateCountdown, 1000);
        updateCountdown();

        // Automatisch na 5 seconden doorsturen
        setTimeout(() => {
            window.location.href = "index.php";
        }, 5000);
    </script>

<?php else: ?>
    <form method="POST">
        <h2>Inloggen</h2>
        <label for="username">Gebruikersnaam:</label>
        <input type="text" id="username" name="username" required>

        <label for="password">Wachtwoord:</label>
        <input type="password" id="password" name="password" required>

        <button type="submit">Inloggen</button>

        <?php if ($error): ?>
            <div class="error"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
    </form>
<?php endif; ?>

</body>
</html>
