<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require 'config.php';

/* === 1?? Verwerk updates === */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update'])) {
    foreach ($_POST['datum_start'] as $id => $start) {
        $eind = $_POST['datum_eind'][$id] ?? null;

        // Lege velden worden NULL
        $start = $start ?: null;
        $eind  = $eind  ?: null;

        $stmt = $pdo->prepare("
            UPDATE exameneenheden
            SET datum_start = :start, datum_eind = :eind
            WHERE id = :id
        ");
        $stmt->execute(['start' => $start, 'eind' => $eind, 'id' => $id]);
    }
    echo "<p class='success'>? Datums succesvol bijgewerkt!</p>";
}

/* === 2?? Haal alle exameneenheden op === */
$stmt = $pdo->query("
    SELECT e.*, v.naam AS vak_naam
    FROM exameneenheden e
    JOIN vakken v ON v.id = e.vak_id
    ORDER BY v.naam, e.datum_start IS NULL, e.datum_start
");
$examens = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Examenplanning ? beheer</title>
    <link rel="stylesheet" href="assets/style.css">
    <style>
        /* Compacte weergave en stijl voor bewerken */
        table.planningbeheer {
            width: 100%;
            border-collapse: collapse;
            background: #1e1e1e;
            margin-top: 20px;
        }
        table.planningbeheer th, table.planningbeheer td {
            border: 1px solid #333;
            padding: 6px 8px;
            text-align: left;
        }
        table.planningbeheer th {
            background: #2a2a2a;
            color: #00bcd4;
        }
        table.planningbeheer input[type="date"] {
            background: #121212;
            border: 1px solid #444;
            color: #eaeaea;
            padding: 3px 5px;
            border-radius: 4px;
        }
        .success {
            background: #1b5e20;
            color: #b2ff59;
            padding: 10px;
            border-radius: 6px;
        }
        .btn-save {
            margin-top: 10px;
            background: #00bcd4;
            border: none;
            color: #121212;
            padding: 8px 14px;
            border-radius: 6px;
            font-weight: bold;
            cursor: pointer;
        }
        .btn-save:hover {
            background: #0097a7;
        }
        h1 {
            color: #00bcd4;
        }
    </style>
</head>
<body>
    <h1>?? Examenplanning ? Beheer alle exameneenheden</h1>
    <form method="post" action="planning.php">
        <table class="planningbeheer">
            <tr>
                <th>Vak</th>
                <th>Exameneenheid</th>
                <th>Type toets</th>
                <th>Datum van</th>
                <th>Datum tot</th>
            </tr>
            <?php foreach ($examens as $ex): ?>
                <tr>
                    <td><?= htmlspecialchars($ex['vak_naam']) ?></td>
                    <td><?= htmlspecialchars($ex['titel']) ?></td>
                    <td><?= htmlspecialchars($ex['type_toets']) ?></td>
                    <td>
                        <input type="date" name="datum_start[<?= $ex['id'] ?>]"
                               value="<?= $ex['datum_start'] ?>">
                    </td>
                    <td>
                        <input type="date" name="datum_eind[<?= $ex['id'] ?>]"
                               value="<?= $ex['datum_eind'] ?>">
                    </td>
                </tr>
            <?php endforeach; ?>
        </table>
        <button class="btn-save" type="submit" name="update">?? Opslaan</button>
    </form>
</body>
</html>

