<?php
require 'config.php';

$vak_id = $_POST['vak_id'] ?? $_GET['vak_id'] ?? null;
if (!$vak_id) die("Geen vak geselecteerd.");

$vak = $pdo->prepare("SELECT * FROM vakken WHERE id=?");
$vak->execute([$vak_id]);
$vak = $vak->fetch();

$onderdelen = $pdo->prepare("SELECT * FROM onderdelen WHERE vak_id=?");
$onderdelen->execute([$vak_id]);
$onderdelen = $onderdelen->fetchAll();
?>
<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars($vak['naam']) ?></title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <h1><?= htmlspecialchars($vak['naam']) ?></h1>
    <p><?= htmlspecialchars($vak['beschrijving']) ?></p>
    <a href="index.php">← Terug naar overzicht</a>

    <h2>Onderdelen</h2>
    <table>
        <tr><th>Onderdeel</th><th>Theorie</th><th>Oefenstof</th><th>Toetsmomenten</th></tr>
        <?php foreach ($onderdelen as $ond): ?>
            <tr>
                <td><?= htmlspecialchars($ond['naam']) ?></td>
                <td>
                    <?php
                    $t = $pdo->prepare("SELECT * FROM theorie_voortgang WHERE onderdeel_id=?");
                    $t->execute([$ond['id']]);
                    if ($tv = $t->fetch()):
                        echo "Voortgang: {$tv['voortgang']}%<br>Beheersing: {$tv['beheersing']}";
                    else:
                        echo "Nog niet ingevuld";
                    endif;
                    ?>
                </td>
                <td>
                    <?php
                    $oef = $pdo->prepare("SELECT * FROM oefenstof WHERE onderdeel_id=?");
                    $oef->execute([$ond['id']]);
                    foreach ($oef as $row) {
                        echo "<div>{$row['omschrijving']}</div>";
                    }
                    ?>
                </td>
                <td>
                    <?php
                    $toets = $pdo->prepare("SELECT * FROM toetsmomenten WHERE onderdeel_id=? ORDER BY datum");
                    $toets->execute([$ond['id']]);
                    foreach ($toets as $t) {
                        echo "<div>{$t['datum']}: {$t['omschrijving']} ({$t['resultaat']})</div>";
                    }
                    ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>
